<?php
echo "=== Checking Database State ===\n\n";

// Test both database configurations
$databases = [
    'sidd_astro' => [
        'host' => 'localhost',
        'user' => 'sidd_astro',
        'pass' => 'sidd_astro'
    ],
    'astro_sidhi_db' => [
        'host' => 'localhost', 
        'user' => 'sidd_astro',
        'pass' => 'sidd_astro'
    ]
];

foreach ($databases as $dbname => $config) {
    echo "=== Database: $dbname ===\n";
    
    try {
        $pdo = new PDO(
            "mysql:host={$config['host']};dbname={$dbname};charset=utf8",
            $config['user'],
            $config['pass'],
            [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
        );
        
        // Check if settings table exists
        $stmt = $pdo->query("SHOW TABLES LIKE 'settings'");
        if ($stmt->rowCount() > 0) {
            echo "✅ Settings table exists\n";
            
            // Check consultation types
            $stmt = $pdo->query("SELECT setting_key, setting_value FROM settings WHERE setting_key IN ('audio_call_enabled', 'video_call_enabled', 'office_meeting_enabled')");
            $consultation_settings = [];
            while ($row = $stmt->fetch()) {
                $consultation_settings[$row['setting_key']] = $row['setting_value'];
                echo "   {$row['setting_key']}: {$row['setting_value']}\n";
            }
            
            // Check working days
            echo "\nWorking Days:\n";
            $stmt = $pdo->query("SELECT setting_key, setting_value FROM settings WHERE setting_key IN ('monday_booking', 'tuesday_booking', 'wednesday_booking', 'thursday_booking', 'friday_booking', 'saturday_booking', 'sunday_booking')");
            while ($row = $stmt->fetch()) {
                echo "   {$row['setting_key']}: {$row['setting_value']}\n";
            }
            
        } else {
            echo "❌ Settings table does not exist\n";
        }
        
    } catch (Exception $e) {
        echo "❌ Connection failed: " . $e->getMessage() . "\n";
    }
    
    echo "\n";
}

echo "=== Check Complete ===\n";
?> 