<?php
require_once 'config/database.php';

try {
    $pdo = getDBConnection();
    
    echo "=== Current Database State ===\n";
    
    // Check consultation types
    echo "\n1. Consultation Types:\n";
    $stmt = $pdo->query("SELECT setting_key, setting_value FROM settings WHERE setting_key IN ('audio_call_enabled', 'video_call_enabled', 'office_meeting_enabled')");
    while ($row = $stmt->fetch()) {
        echo "   {$row['setting_key']}: {$row['setting_value']}\n";
    }
    
    // Check working days
    echo "\n2. Working Days:\n";
    $stmt = $pdo->query("SELECT setting_key, setting_value FROM settings WHERE setting_key IN ('monday_booking', 'tuesday_booking', 'wednesday_booking', 'thursday_booking', 'friday_booking', 'saturday_booking', 'sunday_booking')");
    while ($row = $stmt->fetch()) {
        echo "   {$row['setting_key']}: {$row['setting_value']}\n";
    }
    
    // Check slot duration
    echo "\n3. Slot Duration:\n";
    $stmt = $pdo->query("SELECT setting_key, setting_value FROM settings WHERE setting_key = 'slot_duration'");
    $row = $stmt->fetch();
    if ($row) {
        echo "   slot_duration: {$row['setting_value']} minutes\n";
    } else {
        echo "   slot_duration: NOT SET\n";
    }
    
    // Check blocked dates
    echo "\n4. Blocked Dates:\n";
    $stmt = $pdo->query("SELECT * FROM blocked_dates ORDER BY block_date DESC LIMIT 5");
    $blocked_dates = $stmt->fetchAll();
    if (empty($blocked_dates)) {
        echo "   No blocked dates found\n";
    } else {
        foreach ($blocked_dates as $date) {
            echo "   {$date['block_date']}: {$date['reason']}\n";
        }
    }
    
    echo "\n=== Test Complete ===\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?> 