﻿<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

require_once "../config/database.php";

if (['REQUEST_METHOD'] == 'OPTIONS') {
    exit(0);
}

try {
     = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
    ->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

     = json_decode(file_get_contents('php://input'), true);
    
     = ['appointment_id'] ?? '';
     = ['status'] ?? '';

    if (empty() || empty()) {
        echo json_encode(["success" => false, "message" => "Missing required fields"]);
        exit;
    }

     = ->prepare("
        UPDATE tatkal_appointments 
        SET status = ?, updated_at = NOW()
        WHERE id = ?
    ");
    
     = ->execute([, ]);

    if () {
        echo json_encode(["success" => true, "message" => "Status updated successfully"]);
    } else {
        echo json_encode(["success" => false, "message" => "Failed to update status"]);
    }

} catch (Exception ) {
    echo json_encode(["success" => false, "message" => "Error: " . ->getMessage()]);
}
?>
