<?php
session_start();
require_once '../config/database.php';

$page_title = 'Dashboard';
$current_page = 'index.php';

$pdo = getDBConnection();

// Get statistics
try {
    // Total users
    $userCount = $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();
    
    // Today's bookings
    $todayBookings = $pdo->query("SELECT COUNT(*) FROM appointments WHERE DATE(created_at) = CURDATE()")->fetchColumn();
    
    // Total bookings
    $totalBookings = $pdo->query("SELECT COUNT(*) FROM appointments")->fetchColumn();
    
    // Today's revenue
    $todayRevenue = $pdo->query("SELECT COALESCE(SUM(amount), 0) FROM appointments WHERE DATE(created_at) = CURDATE() AND status = 'confirmed'")->fetchColumn();
    
    // Tatkal bookings today
    $tatkalToday = $pdo->query("SELECT COUNT(*) FROM tatkal_appointments WHERE DATE(created_at) = CURDATE()")->fetchColumn();
    
    // Recent bookings
    $recentBookings = $pdo->query("
        SELECT user_name, appointment_date, time_slot, amount, status, consultation_type, created_at 
        FROM appointments 
        ORDER BY created_at DESC 
        LIMIT 5
    ")->fetchAll();
    
} catch (Exception $e) {
    $userCount = $todayBookings = $totalBookings = $todayRevenue = $tatkalToday = 0;
    $recentBookings = [];
}

ob_start();
?>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="content-card text-center">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 60px; height: 60px;">
                        <i class="fas fa-users fa-2x"></i>
                    </div>
                </div>
                <div class="flex-grow-1 ms-3 text-start">
                    <h3 class="mb-0 text-primary"><?php echo number_format($userCount); ?></h3>
                    <p class="text-muted mb-0">Total Users</p>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="content-card text-center">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <div class="bg-success text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 60px; height: 60px;">
                        <i class="fas fa-calendar-day fa-2x"></i>
                    </div>
                </div>
                <div class="flex-grow-1 ms-3 text-start">
                    <h3 class="mb-0 text-success"><?php echo number_format($todayBookings); ?></h3>
                    <p class="text-muted mb-0">Today's Bookings</p>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="content-card text-center">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <div class="bg-warning text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 60px; height: 60px;">
                        <i class="fas fa-rupee-sign fa-2x"></i>
                    </div>
                </div>
                <div class="flex-grow-1 ms-3 text-start">
                    <h3 class="mb-0 text-warning">₹<?php echo number_format($todayRevenue); ?></h3>
                    <p class="text-muted mb-0">Today's Revenue</p>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="content-card text-center">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <div class="bg-info text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 60px; height: 60px;">
                        <i class="fas fa-bolt fa-2x"></i>
                    </div>
                </div>
                <div class="flex-grow-1 ms-3 text-start">
                    <h3 class="mb-0 text-info"><?php echo number_format($tatkalToday); ?></h3>
                    <p class="text-muted mb-0">Tatkal Bookings</p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="row mb-4">
    <div class="col-12">
        <div class="content-card">
            <h4 class="mb-3">
                <i class="fas fa-bolt me-2 text-primary"></i>
                Quick Actions
            </h4>
            <div class="row">
                <div class="col-md-3 mb-3">
                    <a href="day_management.php" class="btn btn-outline-primary w-100 h-100 d-flex flex-column align-items-center justify-content-center py-4">
                        <i class="fas fa-calendar-alt fa-2x mb-2"></i>
                        <span>Manage Days</span>
                    </a>
                </div>
                <div class="col-md-3 mb-3">
                    <a href="quotes_management.php" class="btn btn-outline-success w-100 h-100 d-flex flex-column align-items-center justify-content-center py-4">
                        <i class="fas fa-quote-left fa-2x mb-2"></i>
                        <span>Manage Quotes</span>
                    </a>
                </div>
                <div class="col-md-3 mb-3">
                    <a href="booking_management.php" class="btn btn-outline-warning w-100 h-100 d-flex flex-column align-items-center justify-content-center py-4">
                        <i class="fas fa-calendar-check fa-2x mb-2"></i>
                        <span>View Bookings</span>
                    </a>
                </div>
                <div class="col-md-3 mb-3">
                    <a href="settings.php" class="btn btn-outline-info w-100 h-100 d-flex flex-column align-items-center justify-content-center py-4">
                        <i class="fas fa-cog fa-2x mb-2"></i>
                        <span>Settings</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Recent Bookings -->
<div class="row">
    <div class="col-12">
        <div class="content-card">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h4 class="mb-0">
                    <i class="fas fa-clock me-2 text-primary"></i>
                    Recent Bookings
                </h4>
                <a href="booking_management.php" class="btn btn-sm btn-outline-primary">View All</a>
            </div>
            
            <?php if (empty($recentBookings)): ?>
                <div class="text-center py-5">
                    <i class="fas fa-calendar-times fa-3x text-muted mb-3"></i>
                    <p class="text-muted">No recent bookings found</p>
                </div>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Date</th>
                                <th>Time</th>
                                <th>Type</th>
                                <th>Amount</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($recentBookings as $booking): ?>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-2" style="width: 35px; height: 35px;">
                                                <?php echo strtoupper(substr($booking['user_name'], 0, 1)); ?>
                                            </div>
                                            <?php echo htmlspecialchars($booking['user_name']); ?>
                                        </div>
                                    </td>
                                    <td><?php echo date('M d, Y', strtotime($booking['appointment_date'])); ?></td>
                                    <td><?php echo htmlspecialchars($booking['time_slot']); ?></td>
                                    <td>
                                        <span class="badge bg-info">
                                            <?php echo ucwords(str_replace('_', ' ', $booking['consultation_type'])); ?>
                                        </span>
                                    </td>
                                    <td>₹<?php echo number_format($booking['amount']); ?></td>
                                    <td>
                                        <span class="badge bg-<?php echo $booking['status'] == 'confirmed' ? 'success' : ($booking['status'] == 'pending' ? 'warning' : 'danger'); ?>">
                                            <?php echo ucfirst($booking['status']); ?>
                                        </span>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php
$content = ob_get_clean();
include 'layout.php';
?>
