<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require_once '../config/database.php';

// Check if admin is logged in
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: login.php');
    exit;
}

$success_message = '';
$error_message = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Debug: Log POST data
        error_log("Test Settings form submitted: " . print_r($_POST, true));
        
        // Simple test - just save one field
        if (isset($_POST['slot_duration']) && !empty($_POST['slot_duration'])) {
            $slot_duration = (int)$_POST['slot_duration'];
            
            // Try to get database connection
            $pdo = getDBConnection();
            
            // Check if settings table exists
            $table_check = $pdo->query("SHOW TABLES LIKE 'settings'");
            if ($table_check->rowCount() == 0) {
                // Create settings table if it doesn't exist
                $pdo->exec("CREATE TABLE IF NOT EXISTS settings (
                    id INT AUTO_INCREMENT PRIMARY KEY,
                    setting_key VARCHAR(100) UNIQUE NOT NULL,
                    setting_value TEXT,
                    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
                )");
                error_log("Settings table created");
            }
            
            // Try to insert/update the setting
            $stmt = $pdo->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = ?");
            $result = $stmt->execute(['slot_duration', $slot_duration, $slot_duration]);
            
            if ($result) {
                $success_message = "Slot duration updated successfully to: " . $slot_duration;
                error_log("Setting saved successfully: slot_duration = " . $slot_duration);
            } else {
                $error_message = "Failed to save setting";
                error_log("Failed to save setting");
            }
        } else {
            $error_message = "Slot duration is required";
        }
        
    } catch (Exception $e) {
        $error_message = 'Error: ' . $e->getMessage();
        error_log("Test Settings error: " . $e->getMessage());
    }
}

// Get current slot duration
$current_slot_duration = '60';
try {
    $pdo = getDBConnection();
    $stmt = $pdo->query("SELECT setting_value FROM settings WHERE setting_key = 'slot_duration'");
    if ($row = $stmt->fetch()) {
        $current_slot_duration = $row['setting_value'];
    }
} catch (Exception $e) {
    error_log("Error getting current setting: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Test Settings - Astro Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h4>Test Settings</h4>
                    </div>
                    <div class="card-body">
                        <?php if ($success_message) { ?>
                            <div class="alert alert-success">
                                <?php echo htmlspecialchars($success_message); ?>
                            </div>
                        <?php } ?>
                        
                        <?php if ($error_message) { ?>
                            <div class="alert alert-danger">
                                <?php echo htmlspecialchars($error_message); ?>
                            </div>
                        <?php } ?>
                        
                        <form method="POST">
                            <div class="mb-3">
                                <label for="slot_duration" class="form-label">Slot Duration (minutes)</label>
                                <input type="number" class="form-control" id="slot_duration" 
                                       name="slot_duration" 
                                       value="<?php echo htmlspecialchars($current_slot_duration); ?>"
                                       min="15" max="120" step="15" required>
                                <div class="form-text">Duration of each appointment slot</div>
                            </div>
                            
                            <button type="submit" class="btn btn-primary">Save Setting</button>
                        </form>
                        
                        <hr>
                        <h6>Debug Info:</h6>
                        <p><strong>Current Slot Duration:</strong> <?php echo htmlspecialchars($current_slot_duration); ?></p>
                        <p><strong>Form Method:</strong> <?php echo $_SERVER['REQUEST_METHOD']; ?></p>
                        <p><strong>POST Data:</strong> <?php echo !empty($_POST) ? 'Yes' : 'No'; ?></p>
                        <?php if (!empty($_POST)) { ?>
                            <pre><?php echo htmlspecialchars(print_r($_POST, true)); ?></pre>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html> 