﻿-- Create tatkal_settings table
CREATE TABLE IF NOT EXISTS tatkal_settings (
    id INT PRIMARY KEY AUTO_INCREMENT,
    is_enabled TINYINT(1) DEFAULT 1,
    price DECIMAL(10,2) DEFAULT 1500.00,
    max_slots_per_day INT DEFAULT 5,
    advance_booking_days INT DEFAULT 7,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Create tatkal_appointments table
CREATE TABLE IF NOT EXISTS tatkal_appointments (
    id INT PRIMARY KEY AUTO_INCREMENT,
    user_id INT NOT NULL,
    user_name VARCHAR(255) NOT NULL,
    user_mobile VARCHAR(15) NOT NULL,
    appointment_date DATE NOT NULL,
    time_slot VARCHAR(50) NOT NULL,
    amount DECIMAL(10,2) NOT NULL,
    no_of_persons INT DEFAULT 1,
    status ENUM('pending', 'confirmed', 'cancelled', 'completed') DEFAULT 'pending',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
);

-- Insert default settings
INSERT IGNORE INTO tatkal_settings (id, is_enabled, price, max_slots_per_day, advance_booking_days) 
VALUES (1, 1, 1500.00, 5, 7);
