﻿<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

require_once "../config/database.php";

if (['REQUEST_METHOD'] == 'OPTIONS') {
    exit(0);
}

try {
     = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
    ->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

     = json_decode(file_get_contents('php://input'), true);
    
     = ['is_enabled'] ?? 0;
     = ['price'] ?? 1500;
     = ['max_slots_per_day'] ?? 5;
     = ['advance_booking_days'] ?? 7;

     = ->prepare("
        UPDATE tatkal_settings 
        SET is_enabled = ?, price = ?, max_slots_per_day = ?, advance_booking_days = ?, updated_at = NOW()
        WHERE id = 1
    ");
    
     = ->execute([, , , ]);

    if () {
        echo json_encode(["success" => true, "message" => "Settings updated successfully"]);
    } else {
        echo json_encode(["success" => false, "message" => "Failed to update settings"]);
    }

} catch (Exception ) {
    echo json_encode(["success" => false, "message" => "Error: " . ->getMessage()]);
}
?>
