<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once '../config/database.php';

try {
    $pdo = getDBConnection();
    
    switch ($_SERVER['REQUEST_METHOD']) {
        case 'GET':
            // Get all settings and configurations
            $response = [];
            
            // Get settings
            $stmt = $pdo->prepare("SELECT setting_key, setting_value FROM settings");
            $stmt->execute();
            $response['settings'] = $stmt->fetchAll();
            
            // Get day off dates
            $stmt = $pdo->prepare("SELECT * FROM day_off ORDER BY date DESC");
            $stmt->execute();
            $response['day_off'] = $stmt->fetchAll();
            
            // Get slot off times
            $stmt = $pdo->prepare("SELECT * FROM slot_off ORDER BY date DESC, start_time");
            $stmt->execute();
            $response['slot_off'] = $stmt->fetchAll();
            
            echo json_encode([
                'success' => true,
                'data' => $response
            ]);
            break;
            
        case 'POST':
            $input = json_decode(file_get_contents('php://input'), true);
            $action = $input['action'] ?? '';
            
            switch ($action) {
                case 'add_day_off':
                    $stmt = $pdo->prepare("
                        INSERT INTO day_off (date, reason, is_full_day, start_time, end_time) 
                        VALUES (?, ?, ?, ?, ?)
                    ");
                    $stmt->execute([
                        $input['date'],
                        $input['reason'] ?? '',
                        $input['is_full_day'] ?? true,
                        $input['start_time'] ?? null,
                        $input['end_time'] ?? null
                    ]);
                    echo json_encode(['success' => true, 'message' => 'Day off added successfully']);
                    break;
                    
                case 'add_slot_off':
                    $stmt = $pdo->prepare("
                        INSERT INTO slot_off (date, start_time, end_time, reason) 
                        VALUES (?, ?, ?, ?)
                    ");
                    $stmt->execute([
                        $input['date'],
                        $input['start_time'],
                        $input['end_time'],
                        $input['reason'] ?? ''
                    ]);
                    echo json_encode(['success' => true, 'message' => 'Slot off added successfully']);
                    break;
                    
                case 'update_settings':
                    foreach ($input['settings'] as $key => $value) {
                        $stmt = $pdo->prepare("
                            INSERT INTO settings (setting_key, setting_value) 
                            VALUES (?, ?) 
                            ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)
                        ");
                        $stmt->execute([$key, $value]);
                    }
                    echo json_encode(['success' => true, 'message' => 'Settings updated successfully']);
                    break;
                    
                default:
                    throw new Exception('Invalid action');
            }
            break;
            
        case 'DELETE':
            $input = json_decode(file_get_contents('php://input'), true);
            $action = $input['action'] ?? '';
            
            switch ($action) {
                case 'remove_day_off':
                    $stmt = $pdo->prepare("DELETE FROM day_off WHERE id = ?");
                    $stmt->execute([$input['id']]);
                    echo json_encode(['success' => true, 'message' => 'Day off removed successfully']);
                    break;
                    
                case 'remove_slot_off':
                    $stmt = $pdo->prepare("DELETE FROM slot_off WHERE id = ?");
                    $stmt->execute([$input['id']]);
                    echo json_encode(['success' => true, 'message' => 'Slot off removed successfully']);
                    break;
                    
                default:
                    throw new Exception('Invalid action');
            }
            break;
            
        default:
            throw new Exception('Method not allowed');
    }
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database error occurred'
    ]);
}
?> 