<?php
header('Content-Type: text/plain');

echo "=== Checking Live Database State ===\n\n";

try {
    // Connect to live database
    $pdo = new PDO(
        "mysql:host=localhost;dbname=sidd_astro;charset=utf8",
        "sidd_astro",
        "sidd_astro",
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
    
    echo "✅ Connected to database: sidd_astro\n\n";
    
    // Check consultation types
    echo "=== Consultation Types ===\n";
    $stmt = $pdo->query("SELECT setting_key, setting_value FROM settings WHERE setting_key IN ('audio_call_enabled', 'video_call_enabled', 'office_meeting_enabled')");
    while ($row = $stmt->fetch()) {
        echo "   {$row['setting_key']}: '{$row['setting_value']}' (Type: " . gettype($row['setting_value']) . ")\n";
    }
    
    // Check working days
    echo "\n=== Working Days ===\n";
    $stmt = $pdo->query("SELECT setting_key, setting_value FROM settings WHERE setting_key IN ('monday_booking', 'tuesday_booking', 'wednesday_booking', 'thursday_booking', 'friday_booking', 'saturday_booking', 'sunday_booking')");
    while ($row = $stmt->fetch()) {
        echo "   {$row['setting_key']}: '{$row['setting_value']}' (Type: " . gettype($row['setting_value']) . ")\n";
    }
    
    // Check all settings
    echo "\n=== All Settings (First 20) ===\n";
    $stmt = $pdo->query("SELECT setting_key, setting_value FROM settings LIMIT 20");
    while ($row = $stmt->fetch()) {
        echo "   {$row['setting_key']}: '{$row['setting_value']}'\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}

echo "\n=== Check Complete ===\n";
?> 