<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
header('Cache-Control: no-cache, no-store, must-revalidate');
header('Pragma: no-cache');
header('Expires: 0');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once '../config/database.php';

try {
    $pdo = getDBConnection();
    
    // Check if quotes are enabled
    $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = 'quotes_enabled'");
    $stmt->execute();
    $quotes_enabled = $stmt->fetchColumn();
    
    if ($quotes_enabled !== 'on') {
        echo json_encode([
            'success' => false,
            'message' => 'Quotes are currently disabled',
            'quotes' => []
        ]);
        exit;
    }
    
    // Get quotes settings
    $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = 'quotes_rotation_interval'");
    $stmt->execute();
    $rotation_interval = $stmt->fetchColumn() ?: 30;
    
    $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = 'quotes_show_author'");
    $stmt->execute();
    $show_author = $stmt->fetchColumn() ?: 'on';
    
    // Fetch active quotes
    $stmt = $pdo->query("SELECT id, quote_text, author, category, display_order FROM quotes WHERE is_active = 1 ORDER BY display_order, RAND()");
    $quotes = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Format quotes based on settings
    $formatted_quotes = [];
    foreach ($quotes as $quote) {
        $formatted_quote = [
            'id' => $quote['id'],
            'text' => $quote['quote_text'],
            'category' => $quote['category']
        ];
        
        if ($show_author === 'on' && !empty($quote['author'])) {
            $formatted_quote['author'] = $quote['author'];
        }
        
        $formatted_quotes[] = $formatted_quote;
    }
    
    echo json_encode([
        'success' => true,
        'quotes' => $formatted_quotes,
        'settings' => [
            'rotation_interval' => (int)$rotation_interval,
            'show_author' => $show_author === 'on'
        ],
        'timestamp' => time()
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error fetching quotes: ' . $e->getMessage(),
        'quotes' => []
    ]);
}
?> 