<?php
echo "=== Testing API Responses ===\n\n";

// Test 1: Check consultation types API
echo "1. Testing Consultation Types API:\n";
$url1 = "https://astro.siddharthnahar.in/astro_admin/api/check_booking_availability.php?action=check_consultation_types";
echo "URL: $url1\n";

$response1 = @file_get_contents($url1);
if ($response1 !== false) {
    $data1 = json_decode($response1, true);
    if ($data1 && isset($data1['consultation_types'])) {
        echo "✅ API Response:\n";
        echo "   Audio Call: " . ($data1['consultation_types']['audio_call'] ? 'ENABLED' : 'DISABLED') . "\n";
        echo "   Video Call: " . ($data1['consultation_types']['video_call'] ? 'ENABLED' : 'DISABLED') . "\n";
        echo "   Office Meeting: " . ($data1['consultation_types']['office_meeting'] ? 'ENABLED' : 'DISABLED') . "\n";
    } else {
        echo "❌ Invalid response format\n";
    }
} else {
    echo "❌ Could not access API\n";
}

echo "\n";

// Test 2: Check working days API
echo "2. Testing Working Days API:\n";
$url2 = "https://astro.siddharthnahar.in/astro_admin/api/check_booking_availability.php?action=check_working_days";
echo "URL: $url2\n";

$response2 = @file_get_contents($url2);
if ($response2 !== false) {
    $data2 = json_decode($response2, true);
    if ($data2 && isset($data2['working_days'])) {
        echo "✅ API Response:\n";
        foreach ($data2['working_days'] as $day => $enabled) {
            echo "   " . ucfirst($day) . ": " . ($enabled ? 'ENABLED' : 'DISABLED') . "\n";
        }
    } else {
        echo "❌ Invalid response format\n";
    }
} else {
        echo "❌ Could not access API\n";
}

echo "\n";

// Test 3: Check get_settings API
echo "3. Testing Get Settings API:\n";
$url3 = "https://astro.siddharthnahar.in/astro_admin/api/get_settings.php";
echo "URL: $url3\n";

$response3 = @file_get_contents($url3);
if ($response3 !== false) {
    $data3 = json_decode($response3, true);
    if ($data3 && isset($data3['consultation_types'])) {
        echo "✅ API Response:\n";
        echo "   Audio Call: " . ($data3['consultation_types']['audio_call'] ? 'ENABLED' : 'DISABLED') . "\n";
        echo "   Video Call: " . ($data3['consultation_types']['video_call'] ? 'ENABLED' : 'DISABLED') . "\n";
        echo "   Office Meeting: " . ($data3['consultation_types']['office_meeting'] ? 'ENABLED' : 'DISABLED') . "\n";
    } else {
        echo "❌ Invalid response format\n";
    }
} else {
    echo "❌ Could not access API\n";
}

echo "\n=== Test Complete ===\n";
?> 