<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once '../config/database.php';

try {
    // Get database connection
    $pdo = getDBConnection();
    
    // Check if office_meeting_enabled exists
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM settings WHERE setting_key = 'office_meeting_enabled'");
    $stmt->execute();
    $exists = $stmt->fetchColumn();
    
    if ($exists == 0) {
        // Add office_meeting_enabled setting
        $stmt = $pdo->prepare("INSERT INTO settings (setting_key, setting_value) VALUES ('office_meeting_enabled', 'on')");
        $stmt->execute();
        $message = "Added office_meeting_enabled: 'on'";
    } else {
        // Update existing
        $stmt = $pdo->prepare("UPDATE settings SET setting_value = 'on' WHERE setting_key = 'office_meeting_enabled'");
        $stmt->execute();
        $message = "Updated office_meeting_enabled: 'on'";
    }
    
    // Verify the fix
    $stmt = $pdo->query("SELECT setting_key, setting_value FROM settings WHERE setting_key IN ('audio_call_enabled', 'video_call_enabled', 'office_meeting_enabled')");
    $consultation_settings = [];
    while ($row = $stmt->fetch()) {
        $consultation_settings[$row['setting_key']] = $row['setting_value'];
    }
    
    echo json_encode([
        'success' => true,
        'message' => $message,
        'consultation_settings' => $consultation_settings
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?> 