<?php
require_once 'config/database.php';

try {
    $pdo = getDBConnection();
    
    // Create settings table
    $createSettingsTable = "
    CREATE TABLE IF NOT EXISTS settings (
        id INT AUTO_INCREMENT PRIMARY KEY,
        setting_key VARCHAR(100) UNIQUE NOT NULL,
        value TEXT,
        description TEXT,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )";
    
    $pdo->exec($createSettingsTable);
    echo "✅ Settings table created successfully<br>";
    
    // Insert default settings
    $defaultSettings = [
        ['normal_days', '["monday", "tuesday", "wednesday", "thursday", "friday", "saturday"]', 'Normal booking available days'],
        ['tatkal_days', '["monday", "tuesday", "wednesday", "friday"]', 'Tatkal booking available days'],
        ['app_name', 'AstroSidhi', 'Application name'],
        ['app_version', '1.0.0', 'Application version'],
        ['maintenance_mode', '0', 'Maintenance mode (0=off, 1=on)']
    ];
    
    $insertSettings = $pdo->prepare("
        INSERT INTO settings (setting_key, value, description) VALUES (?, ?, ?)
        ON DUPLICATE KEY UPDATE 
        value = VALUES(value),
        description = VALUES(description)
    ");
    
    foreach ($defaultSettings as $setting) {
        $insertSettings->execute($setting);
    }
    
    echo "✅ Default settings inserted successfully<br>";
    
    // Check if settings exist
    $checkSettings = $pdo->query("SELECT COUNT(*) FROM settings");
    $count = $checkSettings->fetchColumn();
    
    echo "✅ Database setup completed! Total settings: $count<br>";
    echo "<br><a href='admin/index.php' class='btn btn-primary'>Go to Admin Dashboard</a>";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage();
}
?>
