<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

require_once '../config/database.php';

try {
    $pdo = getDBConnection();
    
    // Create consultation_types table if it doesn't exist
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS consultation_types (
            id INT AUTO_INCREMENT PRIMARY KEY,
            type_name VARCHAR(100) NOT NULL,
            type_code VARCHAR(50) UNIQUE NOT NULL,
            base_price DECIMAL(10,2) NOT NULL DEFAULT 0.00,
            description TEXT,
            is_active BOOLEAN DEFAULT TRUE,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            INDEX idx_type_code (type_code),
            INDEX idx_is_active (is_active)
        )
    ");
    
    // Check if table has data, if not insert defaults
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM consultation_types");
    $count = $stmt->fetch()['count'];
    
    if ($count == 0) {
        $pdo->exec("
            INSERT INTO consultation_types (type_name, type_code, base_price, description, is_active) VALUES
            ('Video Call', 'video_call', 500.00, 'Online video consultation via video call', TRUE),
            ('Audio Call', 'audio_call', 400.00, 'Online audio consultation via phone call', TRUE),
            ('Office Meeting', 'office_meeting', 600.00, 'In-person consultation at office', TRUE),
            ('Tatkal Booking', 'tatkal_booking', 1500.00, 'Emergency/urgent consultation booking', TRUE)
        ");
    }
    
    // Get active consultation types
    $stmt = $pdo->prepare("
        SELECT 
            type_name,
            type_code,
            base_price,
            description
        FROM consultation_types 
        WHERE is_active = 1 
        ORDER BY id ASC
    ");
    $stmt->execute();
    $consultationTypes = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Format the response
    $formattedTypes = [];
    foreach ($consultationTypes as $type) {
        $formattedTypes[] = [
            'type_name' => $type['type_name'],
            'type_code' => $type['type_code'],
            'base_price' => (float)$type['base_price'],
            'description' => $type['description']
        ];
    }
    
    echo json_encode([
        'success' => true,
        'consultation_types' => $formattedTypes,
        'total_types' => count($formattedTypes)
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'Error fetching consultation types: ' . $e->getMessage()
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database error occurred'
    ]);
}
?>
