<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Testing Time Slot Generation</h2>";

// Simulate the slot generation logic
$slotsPerHour = 3; // Set to 3 as per your requirement
$startTime = '09:00';
$endTime = '18:00';
$lunchStart = '13:00';
$lunchEnd = '14:00';

echo "<p><strong>Settings:</strong></p>";
echo "<ul>";
echo "<li>Slots per hour: {$slotsPerHour}</li>";
echo "<li>Start time: {$startTime}</li>";
echo "<li>End time: {$endTime}</li>";
echo "<li>Lunch start: {$lunchStart}</li>";
echo "<li>Lunch end: {$lunchEnd}</li>";
echo "</ul>";

// Calculate actual slot duration based on slots per hour
$actualSlotDuration = 60 / $slotsPerHour;
echo "<p><strong>Calculated slot duration:</strong> {$actualSlotDuration} minutes</p>";

// Generate time slots
$slots = [];
$currentTime = new DateTime($startTime);
$endDateTime = new DateTime($endTime);

echo "<p><strong>Generated Slots:</strong></p>";
echo "<ul>";

while ($currentTime < $endDateTime) {
    $slotStart = $currentTime->format('H:i');
    
    // Add the calculated slot duration
    $currentTime->add(new DateInterval("PT{$actualSlotDuration}M"));
    $slotEnd = $currentTime->format('H:i');
    
    // Check if this slot overlaps with lunch time
    $isLunchTime = ($slotStart >= $lunchStart && $slotEnd <= $lunchEnd);
    
    if (!$isLunchTime) {
        $slots[] = "{$slotStart} - {$slotEnd}";
        echo "<li style='color: green;'>{$slotStart} - {$slotEnd}</li>";
    } else {
        echo "<li style='color: red;'>{$slotStart} - {$slotEnd} (LUNCH TIME - SKIPPED)</li>";
    }
}

echo "</ul>";

echo "<p><strong>Total slots generated:</strong> " . count($slots) . "</p>";

// Calculate expected slots
$workingHours = 9; // 9 AM to 6 PM = 9 hours
$expectedSlots = ($workingHours * $slotsPerHour) - 1; // Subtract 1 for lunch hour
echo "<p><strong>Expected slots:</strong> {$expectedSlots} (9 hours × {$slotsPerHour} slots/hour - 1 lunch hour)</p>";

if (count($slots) == $expectedSlots) {
    echo "<p style='color: green; font-weight: bold;'>✅ SUCCESS: Generated {$expectedSlots} slots as expected!</p>";
} else {
    echo "<p style='color: red; font-weight: bold;'>❌ ERROR: Expected {$expectedSlots} slots but got " . count($slots) . "</p>";
}

// Show detailed breakdown
echo "<h3>Detailed Breakdown:</h3>";
echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
echo "<tr><th>Hour</th><th>Slots</th><th>Details</th></tr>";

$currentTime = new DateTime($startTime);
$hour = 9;

while ($currentTime < $endDateTime) {
    $hourStart = $currentTime->format('H:i');
    $currentTime->add(new DateInterval('PT1H'));
    $hourEnd = $currentTime->format('H:i');
    
    // Count slots in this hour
    $hourSlots = 0;
    $slotDetails = [];
    
    foreach ($slots as $slot) {
        $slotStart = explode(' - ', $slot)[0];
        $slotHour = (int)explode(':', $slotStart)[0];
        
        if ($slotHour == $hour) {
            $hourSlots++;
            $slotDetails[] = $slot;
        }
    }
    
    $isLunchHour = ($hour >= 13 && $hour < 14);
    $rowColor = $isLunchHour ? '#ffe6e6' : '#f0f0f0';
    
    echo "<tr style='background-color: {$rowColor};'>";
    echo "<td>{$hourStart} - {$hourEnd}</td>";
    echo "<td>{$hourSlots}</td>";
    echo "<td>" . implode(', ', $slotDetails) . ($isLunchHour ? ' (LUNCH HOUR)' : '') . "</td>";
    echo "</tr>";
    
    $hour++;
}

echo "</table>";
?> 