<?php
session_start();
require_once '../config/database.php';

// Check if admin is logged in
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: login.php');
    exit();
}

$db = getDatabaseConnection();

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'update_booking_days':
                $days = $_POST['days'] ?? [];
                $startTime = $_POST['start_time'] ?? '09:00';
                $endTime = $_POST['end_time'] ?? '18:00';
                
                // Clear existing settings
                $db->query("DELETE FROM booking_settings WHERE setting_key LIKE 'day_%'");
                
                // Insert new settings
                foreach (['monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday'] as $day) {
                    $isEnabled = in_array($day, $days) ? 1 : 0;
                    $stmt = $db->prepare("INSERT INTO booking_settings (setting_key, setting_value) VALUES (?, ?)");
                    $stmt->execute(["day_$day", $isEnabled]);
                }
                
                // Save time settings
                $db->query("DELETE FROM booking_settings WHERE setting_key IN ('start_time', 'end_time')");
                $stmt = $db->prepare("INSERT INTO booking_settings (setting_key, setting_value) VALUES (?, ?)");
                $stmt->execute(['start_time', $startTime]);
                $stmt->execute(['end_time', $endTime]);
                
                $success_message = "Booking days updated successfully!";
                break;
        }
    }
}

// Get current settings
$booking_days = [];
$start_time = '09:00';
$end_time = '18:00';

$stmt = $db->query("SELECT setting_key, setting_value FROM booking_settings WHERE setting_key LIKE 'day_%' OR setting_key IN ('start_time', 'end_time')");
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    if (strpos($row['setting_key'], 'day_') === 0) {
        $day = str_replace('day_', '', $row['setting_key']);
        if ($row['setting_value'] == '1') {
            $booking_days[] = $day;
        }
    } elseif ($row['setting_key'] === 'start_time') {
        $start_time = $row['setting_value'];
    } elseif ($row['setting_key'] === 'end_time') {
        $end_time = $row['setting_value'];
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Booking Days Management - Astro Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .day-checkbox {
            margin: 10px 0;
        }
        .time-input {
            max-width: 150px;
        }
        .status-badge {
            font-size: 0.8em;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <nav class="col-md-3 col-lg-2 d-md-block bg-dark sidebar collapse">
                <div class="position-sticky pt-3">
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link text-white" href="index.php">
                                <i class="fas fa-tachometer-alt"></i> Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link text-white" href="appointments.php">
                                <i class="fas fa-calendar-check"></i> Appointments
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link text-white" href="users.php">
                                <i class="fas fa-users"></i> Users
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link text-white" href="wallet_management.php">
                                <i class="fas fa-wallet"></i> Wallet Management
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link text-white" href="panchang_management.php">
                                <i class="fas fa-calendar-alt"></i> Panchang Management
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link active bg-primary" href="booking_days_management.php">
                                <i class="fas fa-clock"></i> Booking Days
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link text-white" href="settings.php">
                                <i class="fas fa-cog"></i> Settings
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link text-white" href="logout.php">
                                <i class="fas fa-sign-out-alt"></i> Logout
                            </a>
                        </li>
                    </ul>
                </div>
            </nav>

            <!-- Main content -->
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">
                        <i class="fas fa-clock text-primary"></i> 
                        Booking Days Management
                    </h1>
                </div>

                <?php if (isset($success_message)): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle"></i> <?php echo $success_message; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <div class="row">
                    <div class="col-md-8">
                        <div class="card">
                            <div class="card-header bg-primary text-white">
                                <h5 class="mb-0">
                                    <i class="fas fa-calendar-week"></i> 
                                    Configure Available Booking Days
                                </h5>
                            </div>
                            <div class="card-body">
                                <form method="POST">
                                    <input type="hidden" name="action" value="update_booking_days">
                                    
                                    <div class="row">
                                        <div class="col-md-6">
                                            <h6 class="text-primary mb-3">
                                                <i class="fas fa-calendar-day"></i> Select Available Days
                                            </h6>
                                            
                                            <div class="day-checkbox">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="days[]" value="monday" id="monday" <?php echo in_array('monday', $booking_days) ? 'checked' : ''; ?>>
                                                    <label class="form-check-label" for="monday">
                                                        <strong>Monday</strong>
                                                        <span class="badge bg-success ms-2 status-badge">Available</span>
                                                    </label>
                                                </div>
                                            </div>
                                            
                                            <div class="day-checkbox">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="days[]" value="tuesday" id="tuesday" <?php echo in_array('tuesday', $booking_days) ? 'checked' : ''; ?>>
                                                    <label class="form-check-label" for="tuesday">
                                                        <strong>Tuesday</strong>
                                                        <span class="badge bg-success ms-2 status-badge">Available</span>
                                                    </label>
                                                </div>
                                            </div>
                                            
                                            <div class="day-checkbox">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="days[]" value="wednesday" id="wednesday" <?php echo in_array('wednesday', $booking_days) ? 'checked' : ''; ?>>
                                                    <label class="form-check-label" for="wednesday">
                                                        <strong>Wednesday</strong>
                                                        <span class="badge bg-success ms-2 status-badge">Available</span>
                                                    </label>
                                                </div>
                                            </div>
                                            
                                            <div class="day-checkbox">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="days[]" value="thursday" id="thursday" <?php echo in_array('thursday', $booking_days) ? 'checked' : ''; ?>>
                                                    <label class="form-check-label" for="thursday">
                                                        <strong>Thursday</strong>
                                                        <span class="badge bg-success ms-2 status-badge">Available</span>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="day-checkbox">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="days[]" value="friday" id="friday" <?php echo in_array('friday', $booking_days) ? 'checked' : ''; ?>>
                                                    <label class="form-check-label" for="friday">
                                                        <strong>Friday</strong>
                                                        <span class="badge bg-success ms-2 status-badge">Available</span>
                                                    </label>
                                                </div>
                                            </div>
                                            
                                            <div class="day-checkbox">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="days[]" value="saturday" id="saturday" <?php echo in_array('saturday', $booking_days) ? 'checked' : ''; ?>>
                                                    <label class="form-check-label" for="saturday">
                                                        <strong>Saturday</strong>
                                                        <span class="badge bg-success ms-2 status-badge">Available</span>
                                                    </label>
                                                </div>
                                            </div>
                                            
                                            <div class="day-checkbox">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="days[]" value="sunday" id="sunday" <?php echo in_array('sunday', $booking_days) ? 'checked' : ''; ?>>
                                                    <label class="form-check-label" for="sunday">
                                                        <strong>Sunday</strong>
                                                        <span class="badge bg-success ms-2 status-badge">Available</span>
                                                    </label>
                                                </div>
                                            </div>
                                            
                                            <hr class="my-4">
                                            
                                            <h6 class="text-primary mb-3">
                                                <i class="fas fa-clock"></i> Booking Time Range
                                            </h6>
                                            
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <label for="start_time" class="form-label">Start Time</label>
                                                    <input type="time" class="form-control time-input" id="start_time" name="start_time" value="<?php echo $start_time; ?>">
                                                </div>
                                                <div class="col-md-6">
                                                    <label for="end_time" class="form-label">End Time</label>
                                                    <input type="time" class="form-control time-input" id="end_time" name="end_time" value="<?php echo $end_time; ?>">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="mt-4">
                                        <button type="submit" class="btn btn-primary btn-lg">
                                            <i class="fas fa-save"></i> Save Booking Days Configuration
                                        </button>
                                        <button type="button" class="btn btn-secondary btn-lg ms-2" onclick="resetForm()">
                                            <i class="fas fa-undo"></i> Reset
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-header bg-info text-white">
                                <h5 class="mb-0">
                                    <i class="fas fa-info-circle"></i> 
                                    Current Configuration
                                </h5>
                            </div>
                            <div class="card-body">
                                <h6 class="text-info">Available Days:</h6>
                                <div class="mb-3">
                                    <?php if (empty($booking_days)): ?>
                                        <span class="badge bg-danger">No days selected</span>
                                    <?php else: ?>
                                        <?php foreach ($booking_days as $day): ?>
                                            <span class="badge bg-success me-1 mb-1"><?php echo ucfirst($day); ?></span>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </div>
                                
                                <h6 class="text-info">Booking Hours:</h6>
                                <p class="mb-0">
                                    <strong><?php echo $start_time; ?></strong> to <strong><?php echo $end_time; ?></strong>
                                </p>
                                
                                <hr>
                                
                                <h6 class="text-info">Quick Actions:</h6>
                                <div class="d-grid gap-2">
                                    <button class="btn btn-outline-success btn-sm" onclick="selectWeekdays()">
                                        <i class="fas fa-calendar-week"></i> Weekdays Only
                                    </button>
                                    <button class="btn btn-outline-warning btn-sm" onclick="selectWeekend()">
                                        <i class="fas fa-calendar-day"></i> Weekend Only
                                    </button>
                                    <button class="btn btn-outline-info btn-sm" onclick="selectAllDays()">
                                        <i class="fas fa-calendar-check"></i> All Days
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function resetForm() {
            if (confirm('Are you sure you want to reset the form?')) {
                document.querySelector('form').reset();
            }
        }
        
        function selectWeekdays() {
            const weekdays = ['monday', 'tuesday', 'wednesday', 'thursday', 'friday'];
            weekdays.forEach(day => {
                const checkbox = document.getElementById(day);
                if (checkbox) checkbox.checked = true;
            });
            ['saturday', 'sunday'].forEach(day => {
                const checkbox = document.getElementById(day);
                if (checkbox) checkbox.checked = false;
            });
        }
        
        function selectWeekend() {
            const weekend = ['saturday', 'sunday'];
            weekend.forEach(day => {
                const checkbox = document.getElementById(day);
                if (checkbox) checkbox.checked = true;
            });
            ['monday', 'tuesday', 'wednesday', 'thursday', 'friday'].forEach(day => {
                const checkbox = document.getElementById(day);
                if (checkbox) checkbox.checked = false;
            });
        }
        
        function selectAllDays() {
            const allDays = ['monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday'];
            allDays.forEach(day => {
                const checkbox = document.getElementById(day);
                if (checkbox) checkbox.checked = true;
            });
        }
    </script>
</body>
</html> 