<?php
// Test page for main form submission
session_start();
require_once 'config/database.php';

echo "<h1>🧪 Testing Main Form Submission</h1>";
echo "<style>body{font-family:Arial,sans-serif;margin:20px;} .success{color:green;} .error{color:red;} .info{color:blue;}</style>";

try {
    $pdo = getDBConnection();
    echo "<p class='success'>✅ Database connection successful</p>";
    
    // Test form submission
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        echo "<h2>📝 Form Submitted!</h2>";
        echo "<p class='success'>✅ POST data received</p>";
        echo "<p><strong>POST data:</strong></p>";
        echo "<pre>";
        print_r($_POST);
        echo "</pre>";
        
        // Test saving a simple setting
        if (isset($_POST['test_setting'])) {
            try {
                $stmt = $pdo->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = ?");
                $stmt->execute(['test_setting', $_POST['test_setting'], $_POST['test_setting']]);
                echo "<p class='success'>✅ Test setting saved successfully!</p>";
            } catch (Exception $e) {
                echo "<p class='error'>❌ Error saving test setting: " . $e->getMessage() . "</p>";
            }
        }
        
        // Test the exact form structure from settings.php
        if (isset($_POST['update_settings'])) {
            echo "<h3>🎯 Main Settings Form Detected!</h3>";
            echo "<p class='success'>✅ The 'update_settings' button was clicked!</p>";
            
            // Try to save a test setting
            try {
                $stmt = $pdo->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = ?");
                $stmt->execute(['form_test', 'Form working at ' . date('Y-m-d H:i:s'), 'Form working at ' . date('Y-m-d H:i:s')]);
                echo "<p class='success'>✅ Form test setting saved successfully!</p>";
            } catch (Exception $e) {
                echo "<p class='error'>❌ Error saving form test setting: " . $e->getMessage() . "</p>";
            }
        }
    }
    
    // Show test form that mimics the main settings form
    echo "<h2>📝 Test Main Settings Form</h2>";
    echo "<form method='POST' id='testMainForm'>";
    echo "<p><label>Test Setting: <input type='text' name='test_setting' value='test_value_" . time() . "'></label></p>";
    echo "<p><label>Help Mobile: <input type='text' name='help_mobile_number' value='+91 1234567890'></label></p>";
    echo "<p><label>Support Hours: <input type='text' name='support_hours' value='24/7'></label></p>";
    echo "<p><button type='submit' name='update_settings'>Save All Settings (Main Button)</button></p>";
    echo "</form>";
    
    // Show current test settings
    try {
        $stmt = $pdo->prepare("SELECT setting_key, setting_value FROM settings WHERE setting_key IN ('test_setting', 'form_test') ORDER BY updated_at DESC");
        $stmt->execute();
        $test_settings = $stmt->fetchAll();
        
        echo "<h2>📊 Current Test Settings</h2>";
        if (empty($test_settings)) {
            echo "<p class='info'>ℹ️ No test settings found yet</p>";
        } else {
            echo "<p class='success'>✅ Found " . count($test_settings) . " test settings:</p>";
            echo "<ul>";
            foreach ($test_settings as $setting) {
                echo "<li><strong>{$setting['setting_key']}</strong>: " . htmlspecialchars($setting['setting_value']) . "</li>";
            }
            echo "</ul>";
        }
    } catch (Exception $e) {
        echo "<p class='error'>❌ Error reading test settings: " . $e->getMessage() . "</p>";
    }
    
    echo "<hr>";
    echo "<p><a href='admin/settings.php'>🔧 Go to Main Settings</a></p>";
    echo "<p><a href='test_settings_form.php'>🧪 Go to Simple Test Form</a></p>";
    
} catch (Exception $e) {
    echo "<p class='error'>❌ Database connection failed: " . $e->getMessage() . "</p>";
}
?> 