# 🚀 Astro Admin Panel - New Features

## ✨ New Admin Panel Options

The admin panel now includes three powerful new features for managing booking availability:

### 1. 📅 Working Days Management
- **Enable/Disable booking for specific days** using checkboxes
- **Control which days** users can book appointments
- **Real-time updates** - changes take effect immediately
- **Default settings**: Tuesday, Saturday, Sunday enabled; others disabled

### 2. 📞 Consultation Types Management
- **Audio Call**: Enable/disable audio call consultations
- **Video Call**: Enable/disable video call consultations  
- **Chat**: Enable/disable chat consultations
- **Individual control** - you can enable only specific types
- **App integration** - Flutter app automatically shows only enabled types

### 3. 🚫 Specific Date Blocking
- **Block any specific date** from bookings
- **Add reasons** for blocking (optional)
- **View all blocked dates** in a list
- **Unblock dates** easily with one click
- **Future dates only** - cannot block past dates

## 🛠️ Setup Instructions

### Step 1: Run Setup Script
```bash
# Navigate to astro_admin directory
cd astro_admin

# Run the setup script
php setup_blocked_dates.php
```

### Step 2: Access Admin Panel
1. Go to `astro_admin/admin/login.php`
2. Login with your admin credentials
3. Navigate to **Settings** page
4. You'll see the new sections at the bottom

## 📱 API Endpoints for Flutter App

The Flutter app can now check availability using these API endpoints:

### Check All Availability
```
GET /astro_admin/api/check_booking_availability.php?action=check_all&date=2024-12-25
```

**Response:**
```json
{
  "success": true,
  "date": "2024-12-25",
  "is_blocked": false,
  "block_reason": null,
  "is_working_day": true,
  "consultation_types": {
    "audio_call": true,
    "video_call": true,
    "chat": false
  },
  "working_days": {
    "monday": false,
    "tuesday": true,
    "wednesday": false,
    "thursday": false,
    "friday": false,
    "saturday": true,
    "sunday": true
  },
  "can_book": true
}
```

### Check Only Consultation Types
```
GET /astro_admin/api/check_booking_availability.php?action=check_consultation_types
```

### Check Only Working Days
```
GET /astro_admin/api/check_booking_availability.php?action=check_working_days
```

### Check Specific Date
```
GET /astro_admin/api/check_booking_availability.php?action=check_date&date=2024-12-25
```

## 🎯 How It Works

### Working Days
- **Monday**: `monday_booking` setting controls availability
- **Tuesday**: `tuesday_booking` setting controls availability
- **Wednesday**: `wednesday_booking` setting controls availability
- **Thursday**: `thursday_booking` setting controls availability
- **Friday**: `friday_booking` setting controls availability
- **Saturday**: `saturday_booking` setting controls availability
- **Sunday**: `sunday_booking` setting controls availability

### Consultation Types
- **Audio Call**: `audio_call_enabled` setting
- **Video Call**: `video_call_enabled` setting
- **Office Meeting**: `office_meeting_enabled` setting

### Date Blocking
- **Blocked dates** are stored in `blocked_dates` table
- **Unique constraint** prevents blocking same date twice
- **Admin tracking** shows who blocked each date
- **Reason field** for documentation

## 🔧 Database Tables

### New Table: `blocked_dates`
```sql
CREATE TABLE blocked_dates (
    id INT AUTO_INCREMENT PRIMARY KEY,
    block_date DATE NOT NULL UNIQUE,
    reason VARCHAR(255),
    created_by VARCHAR(100) DEFAULT 'admin',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);
```

### Updated Table: `settings`
New settings added:
- `audio_call_enabled` (on/off)
- `video_call_enabled` (on/off)
- `office_meeting_enabled` (on/off)

## 📱 Flutter App Integration

The Flutter app will automatically:
1. **Check working days** before showing date picker
2. **Hide blocked dates** from calendar
3. **Show only enabled consultation types** in booking form
4. **Display appropriate messages** when booking is not available

## 🎨 Admin Panel UI

### Working Days Section
- **7 day checkboxes** with ON/OFF options
- **Visual indicators** for enabled/disabled days
- **Save button** to apply changes

### Consultation Types Section
- **3 consultation type toggles** (Audio, Video, Chat)
- **Individual control** for each type
- **Helpful descriptions** for each option

### Date Blocking Section
- **Date picker** for selecting dates to block
- **Reason input** for documentation
- **Block button** to apply blocking
- **List of blocked dates** with unblock options

## 🚀 Benefits

1. **Flexible Scheduling**: Control exactly when bookings are allowed
2. **Holiday Management**: Block specific dates for holidays or personal time
3. **Service Control**: Enable only the consultation types you want to offer
4. **Real-time Updates**: Changes take effect immediately
5. **Easy Management**: Simple interface for complex booking rules
6. **Mobile Integration**: Flutter app automatically respects all settings

## 🔒 Security Features

- **Admin authentication required** for all changes
- **Session validation** on every request
- **SQL injection protection** with prepared statements
- **Input validation** for all form fields
- **Audit trail** for blocked dates (who blocked, when, why)

## 📞 Support

If you need help with the new features:
1. Check the setup script output for any errors
2. Verify database tables were created correctly
3. Ensure admin login is working
4. Check API endpoints are accessible

---

**🎉 Enjoy your enhanced admin panel!** 🎉 