# Appointments Management System

## Features

### 1. Advanced Filtering
- **Search**: Search by name, mobile, or city
- **Status Filter**: Filter by appointment status (Pending, Confirmed, Cancelled, Completed)
- **Date Filter**: Filter by specific appointment date
- **Consultation Type**: Filter by meeting type (Office Meeting, Video Call, Audio Call)
- **Amount Range**: Filter by minimum and maximum amount

### 2. Real-time Search
- Search updates automatically after 800ms of typing
- Amount filters update after 1000ms of input
- Dropdown filters update immediately on change

### 3. Export Functionality
- **CSV Export**: Download appointments data in CSV format
- **PDF Export**: Generate HTML report that can be converted to PDF
- Exports respect all applied filters

### 4. Enhanced UI/UX
- Responsive design with Bootstrap 5
- Beautiful gradient statistics cards
- Color-coded appointment status indicators
- Hover effects and smooth transitions
- Loading states during filter operations

### 5. Data Management
- Update appointment status directly from the list
- Delete appointments with confirmation
- View detailed appointment information
- Send notifications (placeholder functionality)

### 6. Pagination
- 25 appointments per page
- Smart pagination with current page highlighting
- Maintains filter state across pages

## Usage

### Applying Filters
1. Use the search box to find specific users by name, mobile, or city
2. Select status from the dropdown to filter by appointment status
3. Pick a date to see appointments on that specific day
4. Choose consultation type to filter by meeting method
5. Set amount range to filter by price
6. Click "Apply Filters" or let filters update automatically

### Exporting Data
1. **CSV Export**: Click "Export CSV" button to download filtered data
2. **PDF Export**: Click "Export PDF" button to generate HTML report

### Managing Appointments
1. **Change Status**: Use the dropdown to update appointment status
2. **Delete**: Click delete button (confirmation required)
3. **View Details**: Click view button to see appointment information
4. **Send Notification**: Click notify button (placeholder)

## Technical Details

### Files
- `appointments.php` - Main appointments management page
- `generate_pdf.php` - PDF/HTML export generation
- `database.php` - Database connection (from config folder)

### Database Tables
- `appointments` - Appointment data
- `users` - User information (joined with appointments)

### Security
- Session-based authentication required
- SQL injection protection with prepared statements
- XSS protection with htmlspecialchars

### Performance
- Efficient database queries with proper indexing
- Pagination to handle large datasets
- Debounced search to reduce server load

## Customization

### Adding New Filters
1. Add filter variables in PHP section
2. Update WHERE conditions
3. Add form elements in HTML
4. Update JavaScript event handlers

### Modifying Export Format
1. Edit CSV headers and data in `appointments.php`
2. Modify HTML template in `generate_pdf.php`
3. Add new export formats as needed

### Styling Changes
- Modify CSS in the `<style>` section
- Update Bootstrap classes for layout changes
- Customize color schemes and gradients

## Troubleshooting

### Common Issues
1. **Filters not working**: Check database connection and table structure
2. **Export fails**: Verify file permissions and PHP configuration
3. **Search slow**: Check database indexes on searchable fields
4. **Pagination broken**: Ensure proper parameter handling in URLs

### Performance Tips
1. Add database indexes on frequently filtered fields
2. Limit export data size for very large datasets
3. Consider caching for frequently accessed data
4. Optimize database queries for better performance 