<?php
session_start();

// Define admin access constant
define('ADMIN_ACCESS', true);

// Check if admin is logged in
function isAdminLoggedIn() {
    return isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;
}

// Require admin login
function requireAdminLogin() {
    if (!isAdminLoggedIn()) {
        header('Location: login.php');
        exit();
    }
}

// Get admin user data
function getAdminUser() {
    return $_SESSION['admin_user'] ?? null;
}

// Admin login function
function adminLogin($username, $password) {
    require_once '../config/database.php';
    $pdo = getDBConnection();
    
    try {
        // For now, use a simple admin check
        // In production, you should have an admin_users table
        if ($username === 'admin' && $password === 'admin123') {
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['admin_user'] = [
                'id' => 1,
                'username' => 'admin',
                'name' => 'Administrator'
            ];
            return true;
        }
        return false;
    } catch (Exception $e) {
        error_log("Admin login error: " . $e->getMessage());
        return false;
    }
}

// Admin logout function
function adminLogout() {
    session_destroy();
    header('Location: login.php');
    exit();
}
?> 