<?php
header('Content-Type: text/plain');

echo "=== Adding Missing Office Meeting Setting ===\n\n";

try {
    // Connect to database
    $pdo = new PDO(
        "mysql:host=localhost;dbname=sidd_astro;charset=utf8",
        "sidd_astro",
        "sidd_astro",
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
    
    echo "✅ Connected to database: sidd_astro\n\n";
    
    // Check if office_meeting_enabled exists
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM settings WHERE setting_key = 'office_meeting_enabled'");
    $stmt->execute();
    $exists = $stmt->fetchColumn();
    
    if ($exists == 0) {
        // Add office_meeting_enabled setting
        $stmt = $pdo->prepare("INSERT INTO settings (setting_key, setting_value) VALUES ('office_meeting_enabled', 'on')");
        $stmt->execute();
        echo "✅ Added office_meeting_enabled: 'on'\n";
    } else {
        // Update existing
        $stmt = $pdo->prepare("UPDATE settings SET setting_value = 'on' WHERE setting_key = 'office_meeting_enabled'");
        $stmt->execute();
        echo "✅ Updated office_meeting_enabled: 'on'\n";
    }
    
    // Verify the fix
    echo "\n=== Updated Consultation Types ===\n";
    $stmt = $pdo->query("SELECT setting_key, setting_value FROM settings WHERE setting_key IN ('audio_call_enabled', 'video_call_enabled', 'office_meeting_enabled')");
    while ($row = $stmt->fetch()) {
        echo "   {$row['setting_key']}: '{$row['setting_value']}'\n";
    }
    
    echo "\n✅ Office Meeting setting added successfully!\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}

echo "\n=== Fix Complete ===\n";
?> 