<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
header('Cache-Control: no-cache, no-store, must-revalidate');
header('Pragma: no-cache');
header('Expires: 0');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

require_once '../config/database.php';

try {
    $pdo = getDBConnection();
    
    // Get all settings
    $stmt = $pdo->prepare("SELECT setting_key, setting_value FROM settings");
    $stmt->execute();
    
    $settings = [];
    while ($row = $stmt->fetch()) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
    
    if (empty($settings)) {
        throw new Exception('No settings found');
    }
    
    // Get consultation types
    $consultation_types = [
        'audio_call' => ($settings['audio_call_enabled'] ?? 'on') === 'on',
        'video_call' => ($settings['video_call_enabled'] ?? 'on') === 'on',
        'office_meeting' => ($settings['office_meeting_enabled'] ?? 'on') === 'on'
    ];
    
    // Get working days
    $working_days = [
        'monday' => ($settings['monday_booking'] ?? 'off') === 'on',
        'tuesday' => ($settings['tuesday_booking'] ?? 'off') === 'on',
        'wednesday' => ($settings['wednesday_booking'] ?? 'off') === 'on',
        'thursday' => ($settings['thursday_booking'] ?? 'off') === 'on',
        'friday' => ($settings['friday_booking'] ?? 'off') === 'on',
        'saturday' => ($settings['saturday_booking'] ?? 'off') === 'on',
        'sunday' => ($settings['sunday_booking'] ?? 'off') === 'on'
    ];
    
    // Debug: Log what's being returned
    error_log("get_settings.php called - consultation_types: " . json_encode($consultation_types));
    error_log("get_settings.php called - working_days: " . json_encode($working_days));
    
    echo json_encode([
        'success' => true,
        'settings' => $settings,
        'advance_booking_days' => (int)($settings['advance_booking_days'] ?? 30),
        'slot_duration' => (int)($settings['slot_duration'] ?? 60),
        'slots_per_hour' => (int)($settings['slots_per_hour'] ?? 3),
        'start_time' => $settings['start_time'] ?? '09:00',
        'end_time' => $settings['end_time'] ?? '18:00',
        'tuesday_price' => (int)($settings['tuesday_price'] ?? 300),
        'saturday_price' => (int)($settings['saturday_price'] ?? 300),
        'sunday_price' => (int)($settings['sunday_price'] ?? 300),
        'other_days_price' => (int)($settings['other_days_price'] ?? 500),
        'system_enabled' => $settings['system_enabled'] ?? '1',
        'consultation_types' => $consultation_types,
        'working_days' => $working_days,
        'timestamp' => time(), // Force refresh
        'debug_info' => 'Settings updated at ' . date('Y-m-d H:i:s')
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database error occurred'
    ]);
}
?> 