<?php
// Test script for new admin panel features
require_once 'config/database.php';

echo "<h1>🧪 Testing New Admin Panel Features</h1>";
echo "<style>body{font-family:Arial,sans-serif;margin:20px;} .success{color:green;} .error{color:red;} .info{color:blue;}</style>";

try {
    $pdo = getDBConnection();
    echo "<p class='success'>✅ Database connection successful</p>";
    
    // Test 1: Check if blocked_dates table exists
    echo "<h2>1. Testing Blocked Dates Table</h2>";
    try {
        $stmt = $pdo->query("DESCRIBE blocked_dates");
        $columns = $stmt->fetchAll();
        echo "<p class='success'>✅ blocked_dates table exists with columns:</p>";
        echo "<ul>";
        foreach ($columns as $col) {
            echo "<li><strong>{$col['Field']}</strong> - {$col['Type']}</li>";
        }
        echo "</ul>";
    } catch (Exception $e) {
        echo "<p class='error'>❌ blocked_dates table not found: " . $e->getMessage() . "</p>";
        echo "<p class='info'>💡 Run setup_blocked_dates.php to create the table</p>";
    }
    
    // Test 2: Check consultation type settings
    echo "<h2>2. Testing Consultation Type Settings</h2>";
    $consultation_settings = ['audio_call_enabled', 'video_call_enabled', 'office_meeting_enabled'];
    foreach ($consultation_settings as $setting) {
        $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
        $stmt->execute([$setting]);
        $value = $stmt->fetchColumn();
        if ($value) {
            echo "<p class='success'>✅ {$setting}: {$value}</p>";
        } else {
            echo "<p class='error'>❌ {$setting}: Not found</p>";
        }
    }
    
    // Test 3: Check working days settings
    echo "<h2>3. Testing Working Days Settings</h2>";
    $working_days = ['monday_booking', 'tuesday_booking', 'wednesday_booking', 'thursday_booking', 'friday_booking', 'saturday_booking', 'sunday_booking'];
    foreach ($working_days as $day) {
        $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
        $stmt->execute([$day]);
        $value = $stmt->fetchColumn();
        if ($value) {
            echo "<p class='success'>✅ {$day}: {$value}</p>";
        } else {
            echo "<p class='error'>❌ {$day}: Not found</p>";
        }
    }
    
    // Test 4: Test API endpoint
    echo "<h2>4. Testing API Endpoint</h2>";
    $api_url = "http://" . $_SERVER['HTTP_HOST'] . dirname($_SERVER['REQUEST_URI']) . "/api/check_booking_availability.php?action=check_all&date=" . date('Y-m-d');
    echo "<p class='info'>🔗 API URL: <a href='{$api_url}' target='_blank'>{$api_url}</a></p>";
    
    // Test 5: Insert a test blocked date
    echo "<h2>5. Testing Date Blocking</h2>";
    try {
        $test_date = date('Y-m-d', strtotime('+1 day'));
        $stmt = $pdo->prepare("INSERT INTO blocked_dates (block_date, reason) VALUES (?, ?) ON DUPLICATE KEY UPDATE reason = ?");
        $stmt->execute([$test_date, 'Test blocking', 'Test blocking']);
        echo "<p class='success'>✅ Test blocked date added: {$test_date}</p>";
        
        // Verify it was added
        $stmt = $pdo->prepare("SELECT * FROM blocked_dates WHERE block_date = ?");
        $stmt->execute([$test_date]);
        $blocked = $stmt->fetch();
        if ($blocked) {
            echo "<p class='success'>✅ Blocked date verified in database</p>";
        }
        
        // Clean up test data
        $stmt = $pdo->prepare("DELETE FROM blocked_dates WHERE block_date = ? AND reason = 'Test blocking'");
        $stmt->execute([$test_date]);
        echo "<p class='info'>🧹 Test data cleaned up</p>";
        
    } catch (Exception $e) {
        echo "<p class='error'>❌ Error testing date blocking: " . $e->getMessage() . "</p>";
    }
    
    // Test 6: Check current blocked dates
    echo "<h2>6. Current Blocked Dates</h2>";
    try {
        $stmt = $pdo->query("SELECT * FROM blocked_dates ORDER BY block_date DESC LIMIT 5");
        $blocked_dates = $stmt->fetchAll();
        if (empty($blocked_dates)) {
            echo "<p class='info'>ℹ️ No dates are currently blocked</p>";
        } else {
            echo "<p class='success'>✅ Found " . count($blocked_dates) . " blocked dates:</p>";
            echo "<ul>";
            foreach ($blocked_dates as $date) {
                echo "<li><strong>{$date['block_date']}</strong> - {$date['reason']} (by {$date['created_by']})</li>";
            }
            echo "</ul>";
        }
    } catch (Exception $e) {
        echo "<p class='error'>❌ Error checking blocked dates: " . $e->getMessage() . "</p>";
    }
    
    echo "<h2>🎉 Test Summary</h2>";
    echo "<p class='success'>✅ All tests completed! Check the results above.</p>";
    echo "<p><a href='admin/settings.php'>🔧 Go to Admin Settings</a></p>";
    echo "<p><a href='admin/login.php'>🔐 Go to Admin Login</a></p>";
    
} catch (Exception $e) {
    echo "<p class='error'>❌ Database connection failed: " . $e->getMessage() . "</p>";
    echo "<p class='info'>💡 Please check your database configuration</p>";
}
?> 