<?php
// Simple test page to verify form submission
session_start();
require_once 'config/database.php';

echo "<h1>🧪 Testing Settings Form</h1>";
echo "<style>body{font-family:Arial,sans-serif;margin:20px;} .success{color:green;} .error{color:red;} .info{color:blue;}</style>";

try {
    $pdo = getDBConnection();
    echo "<p class='success'>✅ Database connection successful</p>";
    
    // Test form submission
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        echo "<h2>📝 Form Submitted!</h2>";
        echo "<p class='success'>✅ POST data received</p>";
        echo "<p><strong>POST data:</strong></p>";
        echo "<pre>";
        print_r($_POST);
        echo "</pre>";
        
        // Test saving a simple setting
        if (isset($_POST['test_setting'])) {
            try {
                $stmt = $pdo->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = ?");
                $stmt->execute(['test_setting', $_POST['test_setting'], $_POST['test_setting']]);
                echo "<p class='success'>✅ Test setting saved successfully!</p>";
            } catch (Exception $e) {
                echo "<p class='error'>❌ Error saving test setting: " . $e->getMessage() . "</p>";
            }
        }
    }
    
    // Show test form
    echo "<h2>📝 Test Form</h2>";
    echo "<form method='POST'>";
    echo "<p><label>Test Setting: <input type='text' name='test_setting' value='test_value_" . time() . "'></label></p>";
    echo "<p><button type='submit'>Submit Test Form</button></p>";
    echo "</form>";
    
    // Show current test setting
    try {
        $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = 'test_setting'");
        $stmt->execute();
        $value = $stmt->fetchColumn();
        if ($value) {
            echo "<p class='success'>✅ Current test setting: " . htmlspecialchars($value) . "</p>";
        } else {
            echo "<p class='info'>ℹ️ No test setting found yet</p>";
        }
    } catch (Exception $e) {
        echo "<p class='error'>❌ Error reading test setting: " . $e->getMessage() . "</p>";
    }
    
    echo "<hr>";
    echo "<p><a href='admin/settings.php'>🔧 Go to Main Settings</a></p>";
    
} catch (Exception $e) {
    echo "<p class='error'>❌ Database connection failed: " . $e->getMessage() . "</p>";
}
?> 