<?php
header('Content-Type: text/plain');

echo "=== Setting up Quotes System ===\n\n";

try {
    require_once 'config/database.php';
    $pdo = getDBConnection();
    
    echo "✅ Connected to database\n\n";
    
    // Create quotes table
    echo "Creating quotes table...\n";
    $sql = "CREATE TABLE IF NOT EXISTS quotes (
        id INT AUTO_INCREMENT PRIMARY KEY,
        quote_text TEXT NOT NULL,
        author VARCHAR(255),
        category VARCHAR(100) DEFAULT 'general',
        is_active BOOLEAN DEFAULT TRUE,
        display_order INT DEFAULT 0,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )";
    
    $pdo->exec($sql);
    echo "✅ Quotes table created\n\n";
    
    // Insert default quotes
    echo "Adding default quotes...\n";
    $default_quotes = [
        ['The stars are not to blame for our actions, but they can guide us to better choices.', 'Ancient Wisdom', 'astrology', 1],
        ['Every day is a new beginning, guided by the cosmic energy around us.', 'Cosmic Philosophy', 'motivation', 2],
        ['The universe speaks to those who listen with an open heart.', 'Spiritual Guide', 'spirituality', 3],
        ['Your destiny is written in the stars, but you hold the pen.', 'Modern Astrologer', 'destiny', 4],
        ['The moon and stars are our eternal companions in this journey of life.', 'Celestial Wisdom', 'cosmic', 5]
    ];
    
    $stmt = $pdo->prepare("INSERT INTO quotes (quote_text, author, category, display_order) VALUES (?, ?, ?, ?)");
    
    foreach ($default_quotes as $quote) {
        try {
            $stmt->execute($quote);
            echo "✅ Added: {$quote[0]}\n";
        } catch (Exception $e) {
            if (strpos($e->getMessage(), 'Duplicate entry') !== false) {
                echo "⚠️  Quote already exists: {$quote[0]}\n";
            } else {
                echo "❌ Error adding quote: " . $e->getMessage() . "\n";
            }
        }
    }
    
    echo "\n";
    
    // Add quotes settings
    echo "Adding quotes settings...\n";
    $settings = [
        'quotes_enabled' => 'on',
        'quotes_rotation_interval' => '30',
        'quotes_show_author' => 'on'
    ];
    
    $stmt = $pdo->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)");
    
    foreach ($settings as $key => $value) {
        $stmt->execute([$key, $value]);
        echo "✅ Setting: {$key} = {$value}\n";
    }
    
    echo "\n=== Setup Complete! ===\n";
    echo "You can now access Quotes Management at: /astro_admin/admin/quotes.php\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
?> 