<?php
// Test Login System
// Run this file in your browser to test the login functionality

echo "<h2>🔐 Testing Login System</h2>";

// Test 1: Check if login.php exists
echo "<h3>Test 1: File Existence</h3>";
if (file_exists('server_api/login.php')) {
    echo "✅ login.php exists in server_api directory<br>";
} else {
    echo "❌ login.php not found in server_api directory<br>";
}

if (file_exists('astro_admin/api/login.php')) {
    echo "✅ login.php exists in astro_admin/api directory<br>";
} else {
    echo "❌ login.php not found in astro_admin/api directory<br>";
}

// Test 2: Check database connection
echo "<h3>Test 2: Database Connection</h3>";
try {
    require_once 'astro_admin/config/database.php';
    $pdo = getDBConnection();
    echo "✅ Database connection successful<br>";
    
    // Check if users table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'users'");
    if ($stmt->rowCount() > 0) {
        echo "✅ Users table exists<br>";
        
        // Check if there are any users
        $stmt = $pdo->query("SELECT COUNT(*) as count FROM users");
        $result = $stmt->fetch();
        echo "✅ Users table has {$result['count']} users<br>";
        
        // Show sample users (without passwords)
        $stmt = $pdo->query("SELECT id, name, mobile, city, wallet_status FROM users LIMIT 5");
        $users = $stmt->fetchAll();
        if (count($users) > 0) {
            echo "<br><strong>Sample Users:</strong><br>";
            echo "<table border='1' style='border-collapse: collapse; margin: 10px 0;'>";
            echo "<tr><th>ID</th><th>Name</th><th>Mobile</th><th>City</th><th>Wallet Status</th></tr>";
            foreach ($users as $user) {
                echo "<tr>";
                echo "<td>{$user['id']}</td>";
                echo "<td>{$user['name']}</td>";
                echo "<td>{$user['mobile']}</td>";
                echo "<td>{$user['city']}</td>";
                echo "<td>{$user['wallet_status']}</td>";
                echo "</tr>";
            }
            echo "</table>";
        }
    } else {
        echo "❌ Users table does not exist<br>";
    }
    
} catch (Exception $e) {
    echo "❌ Database connection failed: " . $e->getMessage() . "<br>";
}

// Test 3: Test login API endpoint
echo "<h3>Test 3: Login API Endpoint</h3>";
$loginUrl = 'server_api/login.php';
if (file_exists($loginUrl)) {
    echo "✅ Login endpoint file exists<br>";
    
    // Test with test credentials
    $testData = [
        'mobile' => '9876543210',
        'password' => 'password'
    ];
    
    echo "<br><strong>Testing with credentials:</strong><br>";
    echo "Mobile: {$testData['mobile']}<br>";
    echo "Password: {$testData['password']}<br>";
    
    // Note: This is just a file check, actual API testing would require a web server
    echo "<br><em>Note: To test actual API calls, you need to run this on a web server</em><br>";
    
} else {
    echo "❌ Login endpoint file not found<br>";
}

// Test 4: Check file permissions
echo "<h3>Test 4: File Permissions</h3>";
$files = [
    'server_api/login.php',
    'server_api/register.php',
    'astro_admin/config/database.php'
];

foreach ($files as $file) {
    if (file_exists($file)) {
        $perms = fileperms($file);
        $perms = substr(sprintf('%o', $perms), -4);
        echo "✅ $file - Permissions: $perms<br>";
    } else {
        echo "❌ $file - File not found<br>";
    }
}

echo "<br><h3>🎯 Next Steps:</h3>";
echo "1. Make sure your web server is running<br>";
echo "2. Test the login API with a tool like Postman or curl<br>";
echo "3. Verify the Flutter app can connect to the server<br>";
echo "4. Test with the test user credentials: 9876543210 / password<br>";

echo "<br><h3>🔧 Troubleshooting:</h3>";
echo "• Check database credentials in astro_admin/config/database.php<br>";
echo "• Ensure MySQL/MariaDB is running<br>";
echo "• Check web server logs for errors<br>";
echo "• Verify CORS headers are properly set<br>";
?>