<?php
// Add Help Settings to Database
require_once 'config/database.php';

try {
    $pdo = getDBConnection();
    
    echo "<h2>🔧 Adding Help Settings to Database...</h2>";
    
    // Add help mobile number setting
    $help_mobile = '+91 77373 57224';
    
    $stmt = $pdo->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = ?");
    
    // Help mobile number
    $stmt->execute(['help_mobile_number', $help_mobile, $help_mobile]);
    echo "<p>✅ Help mobile number setting added: $help_mobile</p>";
    
    // Help WhatsApp message template
    $help_message = 'Hi, I need help with the Astro Admin Panel. Can you please assist me?';
    $stmt->execute(['help_whatsapp_message', $help_message, $help_message]);
    echo "<p>✅ Help WhatsApp message template added</p>";
    
    // Support hours
    $support_hours = '24/7 Available';
    $stmt->execute(['support_hours', $support_hours, $support_hours]);
    echo "<p>✅ Support hours setting added: $support_hours</p>";
    
    // Support email
    $support_email = 'support@astro.com';
    $stmt->execute(['support_email', $support_email, $support_email]);
    echo "<p>✅ Support email setting added: $support_email</p>";
    
    // Language support
    $language_support = 'English, Hindi';
    $stmt->execute(['language_support', $language_support, $language_support]);
    echo "<p>✅ Language support setting added: $language_support</p>";
    
    echo "<h3>🎯 All Help Settings Added Successfully!</h3>";
    echo "<p><strong>Help Mobile:</strong> $help_mobile</p>";
    echo "<p><strong>Support Hours:</strong> $support_hours</p>";
    echo "<p><strong>Languages:</strong> $language_support</p>";
    
} catch (Exception $e) {
    echo "<p>❌ Error: " . $e->getMessage() . "</p>";
}
?>

<style>
body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }
h2 { color: #2c3e50; }
h3 { color: #34495e; margin-top: 30px; }
p { background: white; padding: 10px; margin: 5px 0; border-radius: 5px; border-left: 4px solid #3498db; }
</style> 